﻿//Class ShapeSphere
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ShapePolymorphism
{
    public class ShapeSphere : Shape3D
    {
        private double radius;

        //Radius property
        public double Radius
        {
            get { return radius; }
            set
            {
                if (value >= 0)
                {
                    radius = value;
                    Area();
                    Volume();
                }
                else
                {
                    MessageBox.Show("Cube side must be positive number", "Invalid number format",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

         //Diameter property - read only
        public double Diameter
        {
            get { return Radius * 2; }
        }

        //Circumfrence propetry - read only
        public double Circumference
        {
            get { return (double)Math.PI * Diameter; }
        }

        //constructor
        public ShapeSphere()
        {
            Name = "Sphere";
        }

        public override string ToString()
        {
            return "P1.Shape3D." + Name;
        }

        //finds surface area of sphere
        public override double Area()
        {
            return (double)Math.PI * 4 * Radius * Radius;
        }

        //finds volume of sphere
        public override double Volume()
        {
            return (double)Math.PI * Radius * Radius * Radius * (4.0 / 3.0);
        }
        public override double Side()
        {
            return radius;
        }//End Side

    }   //End class
}  //End namespace
